package gov.va.med.mhv.usermgmt.data.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;
import gov.va.med.mhv.common.data.model.AccessRole;
import gov.va.med.mhv.common.data.model.UserProfile;

@Entity
@Table(name = "USER_PROFILE_ACCESS_ROLE")
public class UserProfileAccessRole extends AbstractBaseEntity {

	private static final long serialVersionUID = -4039337394402255917L;

	@Id
	@Column(name = "USER_PROFILE_ACCESS_ROLE_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "VALUE")
	private Integer value;

	@Column(name = "USER_PROFILE_ID", insertable = false, updatable = false)
	private Long userProfileId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "USER_PROFILE_ID")
	private UserProfile userProfile;

	@Column(name = "ACCESS_ROLE_ID", insertable = false, updatable = false)
	private Long accessRoleId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "ACCESS_ROLE_ID")
	private AccessRole accessRole;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Integer getValue() {
		return value;
	}

	public void setValue(Integer value) {
		this.value = value;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

	public Long getAccessRoleId() {
		return accessRoleId;
	}

	public void setAccessRoleId(Long accessRoleId) {
		this.accessRoleId = accessRoleId;
	}

	public AccessRole getAccessRole() {
		return accessRole;
	}

	public void setAccessRole(AccessRole accessRole) {
		this.accessRole = accessRole;
	}
}
